/*
 * Decompiled with CFR 0.152.
 */
package cds.astro;

import cds.astro.Coo;
import cds.astro.Coocube;
import cds.astro.Region;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Enumeration;

public class Qbox
implements Serializable {
    int qbox;
    private static final double PIO2 = 1.5707963267948966;
    static boolean DEBUG = false;
    static final int ANY = Integer.MIN_VALUE;
    static final int BOX = Integer.MAX_VALUE;
    private static final int MAXLEVEL = 12;
    public static int level = 9;
    static final int QBOX_NONE = 0;
    static final int QBOX_ANY = -1;
    static final int QBOX_SOME = 1;
    private static final char[] oct = "01234567".toCharArray();
    private static final double DEG = 57.29577951308232;
    static final double[] MAXRAD = new double[]{54.735610317, 30.361193405, 16.403086517, 8.639594386, 4.449359566, 2.259674852, 1.138910823, 0.571763982, 0.286464128, 0.14337822, 0.071725727, 0.035872027, 0.017938306};
    static final double[] SINRAD = new double[]{0.816496580927726, 0.5054494651244236, 0.2823931345695149, 0.1502185901567493, 0.0775779474805375, 0.0394285430318791, 0.0198764347423619, 0.0099789983974146, 0.0049997213877594, 0.0025024194021835, 0.0012518497600656, 6.260849416742E-4, 3.130824920569E-4};
    static final double[] MINRAD = new double[]{45.0, 21.793189128656, 9.612900642866, 4.557754524215, 2.213411995038, 1.089949904684, 0.540737084594, 0.269302913463, 0.134384274203, 0.067125244187, 0.03354588668, 0.016768757962, 0.008383332446};

    public static final int setLevel(int n) {
        int n2 = level;
        if (n >= 0 && n <= 12) {
            level = n;
        }
        return n2;
    }

    private static final int center_(int n, double[] dArray) {
        int n2 = n & Integer.MAX_VALUE;
        int n3 = 0;
        int n4 = 0;
        if (n2 < 9) {
            dArray[0] = 0.0;
            dArray[1] = 0.0;
            return 0;
        }
        int n5 = 0;
        while ((n2 & 0xFFFFFFF0) != 0) {
            n4 |= (n2 & 1) << n5;
            n3 |= ((n2 >>>= 1) & 1) << n5;
            n2 >>>= 1;
            ++n5;
        }
        double d = 1 << n5;
        dArray[0] = Math.tan((((double)n3 + 0.5) / d - 0.5) * 1.5707963267948966);
        dArray[1] = Math.tan((((double)n4 + 0.5) / d - 0.5) * 1.5707963267948966);
        return n2;
    }

    public static final int corners(int n, double[] dArray) {
        int n2 = n & Integer.MAX_VALUE;
        int n3 = 0;
        int n4 = 0;
        if (n2 == 0) {
            return 0;
        }
        int n5 = 0;
        while ((n2 & 0xFFFFFFF0) != 0) {
            n4 |= (n2 & 1) << n5;
            n3 |= ((n2 >>= 1) & 1) << n5;
            n2 >>= 1;
            ++n5;
        }
        double d = 1 << n5;
        dArray[0] = Math.tan(((double)n3 / d - 0.5) * 1.5707963267948966);
        dArray[1] = Math.tan(((double)n4 / d - 0.5) * 1.5707963267948966);
        dArray[2] = Math.tan(((double)(++n3) / d - 0.5) * 1.5707963267948966);
        dArray[3] = Math.tan(((double)(++n4) / d - 0.5) * 1.5707963267948966);
        return n2 & 7;
    }

    public static final int ucenter(int n, double[] dArray) {
        double[] dArray2 = new double[2];
        int n2 = Qbox.center_(n, dArray2);
        if (n2 == 0) {
            return n2;
        }
        Coocube.setUvec(n2, dArray2[0], dArray2[1], dArray);
        return n2;
    }

    public static final int ucorners(int n, double[][] dArray) {
        double[] dArray2 = new double[4];
        int n2 = Qbox.corners(n, dArray2);
        if (n2 == 0) {
            return n2;
        }
        Coocube.setUvec(n2, dArray2[0], dArray2[1], dArray[0]);
        Coocube.setUvec(n2, dArray2[2], dArray2[1], dArray[1]);
        Coocube.setUvec(n2, dArray2[2], dArray2[3], dArray[2]);
        Coocube.setUvec(n2, dArray2[0], dArray2[3], dArray[3]);
        return n2;
    }

    private static final void range(int n, int[] nArray) {
        int n2 = n & Integer.MIN_VALUE;
        if ((n & Integer.MAX_VALUE) == 0) {
            nArray[0] = 9 << (level << 1) | n2;
            nArray[1] = 15 << (level << 1) | n2;
        } else {
            nArray[0] = nArray[1] = n;
            int n3 = 8 << (level << 1);
            while ((nArray[0] & n3) == 0) {
                nArray[0] = nArray[0] << 2;
                nArray[1] = nArray[1] << 2 | 3;
            }
            nArray[1] = nArray[1] + 1;
            nArray[0] = nArray[0] | n2;
            nArray[1] = nArray[1] | n2;
        }
    }

    public Qbox() {
        this.qbox = 0;
    }

    public Qbox(Qbox qbox) {
        this.set(qbox);
    }

    public Qbox(Coo coo) {
        this.set(coo);
    }

    private Qbox(int n) {
        this.qbox = n;
    }

    public Qbox(String string) throws ParseException {
        char[] cArray = string.toCharArray();
        int n = 0;
        int n2 = 0;
        this.qbox = 0;
        if (n2 >= cArray.length) {
            return;
        }
        if (cArray[n2] >= '1' && cArray[n2] <= '6') {
            this.qbox = 8 | Character.digit(cArray[n2], 8);
        } else {
            ++n;
        }
        if (++n2 < cArray.length && cArray[n2] == ':') {
            ++n2;
        }
        while (n2 < cArray.length && cArray[n2] >= '0' && cArray[n2] < '4') {
            this.qbox = this.qbox << 2 | Character.digit(cArray[n2], 4);
            ++n2;
        }
        if (n2 < cArray.length && Character.toUpperCase(cArray[n2]) == 'A') {
            ++n2;
            this.qbox |= Integer.MIN_VALUE;
        }
        if (n2 < cArray.length) {
            ++n;
        }
        if (n > 0) {
            throw new ParseException("****Qbox: '" + string + "'+" + n2, n2);
        }
    }

    public static final int level(int n) {
        int n2 = 0;
        if ((n &= Integer.MAX_VALUE) == 0) {
            return -1;
        }
        if ((n & 0x7FFF0000) != 0) {
            n2 = 7;
            n >>>= 14;
        }
        while ((n & 0xFFFFFFF0) != 0) {
            n >>>= 2;
            ++n2;
        }
        return n2;
    }

    public final int level() {
        return Qbox.level(this.qbox);
    }

    public final boolean isAny() {
        return (this.qbox & Integer.MIN_VALUE) != 0;
    }

    public final void toAny() {
        this.qbox |= Integer.MIN_VALUE;
    }

    public final int box() {
        return this.qbox & Integer.MAX_VALUE;
    }

    public final int index() {
        int n;
        int n2 = n = this.level();
        if (n >= 0) {
            n2 = (this.qbox & Integer.MAX_VALUE) - (9 << 2 * n);
        }
        return n2;
    }

    public final int face() {
        int n = this.level();
        if (n < 0) {
            return 0;
        }
        return this.qbox >>> 2 * n & 7;
    }

    public final void set(Coocube coocube) {
        int n;
        this.qbox = coocube.face;
        if (level <= 0) {
            return;
        }
        if (this.qbox == 0) {
            return;
        }
        this.qbox |= 8;
        int n2 = 1 << level;
        double d = (0.5 + Math.atan(coocube.X) / 1.5707963267948966) * (double)n2;
        int n3 = (int)d;
        if (n3 >= n2) {
            n3 = n2 - 1;
        }
        if ((n = (int)(d = (0.5 + Math.atan(coocube.Y) / 1.5707963267948966) * (double)n2)) >= n2) {
            n = n2 - 1;
        }
        this.qbox <<= level << 1;
        n2 >>= 1;
        int n4 = level - 1;
        while (n2 > 0) {
            this.qbox |= (n3 & n2) << n4 << 1 | (n & n2) << n4;
            n2 >>= 1;
            --n4;
        }
    }

    public final void set(Qbox qbox) {
        this.qbox = qbox.qbox;
    }

    public final void set(Coo coo) {
        Coocube coocube = new Coocube(coo);
        this.set(coocube);
    }

    final void set(int n) {
        this.qbox = n;
    }

    public final Coocube center() {
        double[] dArray = new double[2];
        int n = Qbox.center_(this.qbox, dArray);
        return new Coocube(n & 7, dArray[0], dArray[1]);
    }

    public final boolean inside(Coo coo) {
        if (this.qbox == 0) {
            return true;
        }
        double[] dArray = new double[4];
        int n = Qbox.corners(this.qbox & Integer.MAX_VALUE, dArray);
        Coocube coocube = new Coocube(coo);
        if (coocube.face != n) {
            return false;
        }
        return coocube.X >= dArray[0] && coocube.X <= dArray[2] && coocube.Y >= dArray[1] && coocube.Y <= dArray[3];
    }

    public static final double maxRadius() {
        return MAXRAD[level];
    }

    public static final double maxRadius(int n) {
        if (n == 0) {
            return 180.0;
        }
        int n2 = Qbox.level(n);
        if (n2 < 0) {
            return 0.0;
        }
        return MAXRAD[n2];
    }

    public static final double minRadius() {
        return MINRAD[level];
    }

    public static final double minRadius(int n) {
        if (n == 0) {
            return 180.0;
        }
        int n2 = Qbox.level(n);
        if (n2 < 0) {
            return 0.0;
        }
        return MINRAD[n2];
    }

    public final double area() {
        double[] dArray = new double[4];
        Qbox.corners(this.qbox & Integer.MAX_VALUE, dArray);
        for (int i = 0; i < 4; ++i) {
            int n = i;
            dArray[n] = dArray[n] / Math.sqrt(1.0 + dArray[i] * dArray[i]);
        }
        double d = Math.asin(dArray[0] * dArray[1]) + Math.asin(dArray[2] * dArray[3]) - Math.asin(dArray[0] * dArray[3]) - Math.asin(dArray[1] * dArray[2]);
        return 3282.806350011744 * Math.abs(d);
    }

    public final double radius() {
        double[] dArray = new double[4];
        double[] dArray2 = new double[2];
        double d = 0.0;
        Qbox.center_(this.qbox & Integer.MAX_VALUE, dArray2);
        Qbox.corners(this.qbox & Integer.MAX_VALUE, dArray);
        double d2 = 1.0 + dArray2[0] * dArray2[0] + dArray2[1] * dArray2[1];
        for (int i = 0; i < 4; ++i) {
            double d3;
            double d4 = dArray[i & 2];
            double d5 = dArray[(i & 1) << 1 | 1];
            double d6 = d2 * (1.0 + d4 * d4 + d5 * d5);
            double d7 = d4 * dArray2[1] - d5 * dArray2[0];
            d7 *= d7;
            if (!((d3 = (d7 += (d4 -= dArray2[0]) * d4 + (d5 -= dArray2[1]) * d5) / d6) > d)) continue;
            d = d3;
        }
        return 57.29577951308232 * Math.asin(Math.sqrt(d));
    }

    public final Coo[] corners() {
        Coo[] cooArray = new Coo[4];
        double[] dArray = new double[4];
        int n = Qbox.corners(this.qbox, dArray);
        if (n == 0) {
            return cooArray;
        }
        double[] dArray2 = new double[3];
        Coocube.setUvec(n, dArray[0], dArray[1], dArray2);
        cooArray[0] = new Coo(dArray2[0], dArray2[1], dArray2[2]);
        Coocube.setUvec(n, dArray[2], dArray[1], dArray2);
        cooArray[1] = new Coo(dArray2[0], dArray2[1], dArray2[2]);
        Coocube.setUvec(n, dArray[2], dArray[3], dArray2);
        cooArray[2] = new Coo(dArray2[0], dArray2[1], dArray2[2]);
        Coocube.setUvec(n, dArray[0], dArray[3], dArray2);
        cooArray[3] = new Coo(dArray2[0], dArray2[1], dArray2[2]);
        return cooArray;
    }

    public final String toString() {
        char[] cArray = new char[20];
        int n = cArray.length;
        int n2 = this.qbox;
        if ((n2 & Integer.MIN_VALUE) != 0) {
            cArray[--n] = 65;
            n2 &= Integer.MAX_VALUE;
        }
        while ((n2 & 0xFFFFFFF0) != 0) {
            cArray[--n] = oct[n2 & 3];
            n2 >>>= 2;
        }
        if (n2 != 0) {
            cArray[--n] = 58;
        }
        cArray[--n] = oct[n2 & 7];
        return new String(cArray, n, cArray.length - n);
    }

    private static final void call_down(int n, Region region, ArrayList<Qbox> arrayList) {
        int n2;
        int n3;
        int n4 = 8 << (level << 1);
        if (n == 0) {
            n3 = 9;
            n2 = 14;
        } else {
            n3 = n << 2;
            n2 = n3 | 3;
        }
        for (int i = n3; i <= n2; ++i) {
            int n5 = region.checkQbox(i);
            if (n5 == 0) {
                if (!DEBUG) continue;
                System.out.println("#...checkQ(" + i + ") => NONE");
                continue;
            }
            if (n5 == -1) {
                if (DEBUG) {
                    System.out.println("#...checkQ(" + i + ") => +ANY");
                }
                arrayList.add(new Qbox(i | Integer.MIN_VALUE));
                continue;
            }
            if ((i & n4) != 0) {
                if (DEBUG) {
                    System.out.println("#...checkQ(" + i + ") => +add");
                }
                arrayList.add(new Qbox(i));
                continue;
            }
            if (DEBUG) {
                System.out.println("#...checkQ(" + i + ") => ....");
            }
            Qbox.call_down(i, region, arrayList);
        }
    }

    static ArrayList in_region(Region region) {
        ArrayList<Qbox> arrayList = new ArrayList<Qbox>();
        if (region.maxrad < MAXRAD[level]) {
            Qbox qbox = new Qbox(region.centroid);
            if (region.checkQbox(qbox.qbox) == 3) {
                arrayList.add(qbox);
                return arrayList;
            }
        }
        Qbox.call_down(0, region, arrayList);
        return arrayList;
    }

    public Enumeration list() {
        return new Enumeration(){
            int[] qb;
            {
                this.qb = new int[]{Qbox.this.qbox, 0};
            }

            @Override
            public boolean hasMoreElements() {
                if (this.qb[1] == 0) {
                    Qbox.range(this.qb[0], this.qb);
                }
                return this.qb[0] < this.qb[1];
            }

            public Object nextElement() {
                Qbox qbox = new Qbox();
                int n = this.qb[0];
                this.qb[0] = n + 1;
                qbox.qbox = n;
                return qbox;
            }
        };
    }

    public static Enumeration list(final ArrayList arrayList) {
        return new Enumeration(){
            ArrayList v;
            int pos;
            int[] qb;
            {
                this.v = arrayList;
                this.pos = 0;
                this.qb = new int[]{0, 0};
            }

            @Override
            public boolean hasMoreElements() {
                if (this.qb[0] >= this.qb[1]) {
                    if (this.pos >= this.v.size()) {
                        return false;
                    }
                    Qbox qbox = (Qbox)this.v.get(this.pos++);
                    Qbox.range(qbox.qbox, this.qb);
                }
                return true;
            }

            public Object nextElement() {
                Qbox qbox = new Qbox(this.qb[0]);
                this.qb[0] = this.qb[0] + 1;
                return qbox;
            }
        };
    }

    public static Enumeration list(Region region) {
        ArrayList arrayList = Qbox.in_region(region);
        return Qbox.list(arrayList);
    }

    public static Enumeration circle(Coo coo, double d) {
        return Qbox.list(Region.circle(coo, d));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        boolean bl = false;
        if (object instanceof Qbox) {
            bl = ((Qbox)object).qbox == this.qbox;
        }
        return bl;
    }

    public int hashCode() {
        return 123 * this.qbox;
    }
}

